
#ifndef _1_KMNG_EXT_ATP_TESTDATA_DEFINES_h_H
#define _1_KMNG_EXT_ATP_TESTDATA_DEFINES_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "KMNG_SEP_ATP_Defines.h"
#include "KMNG_Defs.h"

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon March 30 10:18:14 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains structure defines of the test vectors
   *
   *  \version KMNG_SEP_ATP_TestDataDefines.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


  /************************ Defines *******************************/

  /************************ Enums *********************************/
  /************************ Typedefs  *****************************/
  /************************ Structs  ******************************/
	
	/* Context key data structure for symmetric (AES and HMAC) keys */
	typedef struct TST_Ext_KeysSym_TestDataStruct{	
		DxChar		    		    TST_Name[TST_NAME_STRING_LEN];
		DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_PwdLen;
		DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_KeyPwdLen;
		DxUint32_t                  TST_KeyID;
		KMNG_KeyType_t              TST_KeyType;
		DxUint32_t                  TST_KeyUsage;
		DxUint32_t                  TST_KeyRestriction;
		DxUint8_t                   TST_key[TST_KMNG_SYM_KEY_MAX_SIZE];
		DxUint32_t                  TST_KeySize;
		DxUint8_t                   TST_Exportedkey[TST_KMNG_SYM_KEY_MAX_SIZE];
		CRYS_AES_IvCounter_t        TST_IV;
		CRYS_AES_OperationMode_t    TST_AESMode;
		CRYS_DES_OperationMode_t    TST_DESMode;
		CRYS_HASH_OperationMode_t   TST_HASHMode;
		DxUint8_t                   TST_Data[TST_KMNG_MAX_SIZE_DATA];
		DxUint32_t                  TST_DataLen;
		DxUint8_t                   TST_ExpectedOutput[TST_KMNG_MAX_SIZE_DATA];
		DxUint8_t                   TST_OutputData[TST_KMNG_MAX_SIZE_DATA];
		DxUint32_t                  TST_OutputLen;
		DxUint8_t                   TST_VerifyOutput;
		KMNG_UserSpecificKeyData_t  TST_UserData;

	} TST_Ext_KeysSym_TestDataStruct;

	/* Context key data structure for RSA keys */
	typedef struct TST_Ext_KeysRSA_TestDataStruct{	
		DxChar		    		    TST_Name[TST_NAME_STRING_LEN];
		DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_PwdLen;
		DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_KeyPwdLen;
		DxUint32_t                  TST_KeyID;
		KMNG_KeyType_t              TST_KeyType;
		DxUint32_t                  TST_KeyUsage;
		DxUint32_t                  TST_KeyRestriction;
		DxUint32_t                  TST_KeySize;
		CRYS_PKCS1_version		    TST_PKCS1_ver;
		CRYS_RSA_HASH_OpMode_t      TST_HASHMode;
		DxUint8_t                   TST_E[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_ESize;
		DxUint8_t                   TST_ExportedE[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_ExportedESize;
		DxUint8_t                   TST_N[TST_KMNG_MAX_RSA_PARAM_SIZE];
		DxUint32_t                  TST_NSize;
		DxUint8_t                   TST_ExportedN[TST_KMNG_MAX_RSA_PARAM_SIZE];
		DxUint32_t                  TST_ExportedNSize;  
		DxUint8_t                   TST_D[TST_KMNG_MAX_RSA_PARAM_SIZE];
		DxUint32_t                  TST_DSize;
		DxUint8_t                   TST_ExportedD[TST_KMNG_MAX_RSA_PARAM_SIZE];
		DxUint32_t                  TST_ExportedDSize;
		DxUint8_t                   TST_Data[TST_KMNG_MAX_SIZE_DATA];
		DxUint16_t                  TST_DataLen;
		DxUint8_t                   TST_ExpectedOutput[TST_KMNG_MAX_SIZE_DATA];
		DxUint16_t                  TST_OutputLen;
		DxUint8_t                   TST_VerifyOutput;
		KMNG_UserSpecificKeyData_t  TST_UserData;
	} TST_Ext_KeysRSA_TestDataStruct;  

/************************ Global Data ***************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/


#ifdef __cplusplus
}
#endif

#endif
